/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx__block.c,v 1.7 2006/08/31 01:51:55 bgoglin Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__block.h"
#include "mx__shim.h"
#include "mx__valgrind.h"

void mx__make_chain(mx__block *b, char *p, int max_size, int size)
{
  int i;

  b->p = p;
  b->max = max_size/size;
  b->size = size;
  b->count = 0;

  MX_VALGRIND_MEMORY_MAKE_NOACCESS(p, max_size);
  for (i = 0; i < b->max-1; ++i) {
    MX_VALGRIND_MEMORY_MAKE_WRITABLE(p + i * size, sizeof(char*));
    *(char**)(p + i * size) = p + (i+1) * size;
  }
  MX_VALGRIND_MEMORY_MAKE_WRITABLE(p + (b->max-1) * size, sizeof(char*));
  *(char**)(p + (b->max-1) * size) = NULL;
}

void *mx__alloc_block(mx__block *b)
{
  char *p = NULL;

  if (b->count < b->max) {
    p = b->p;
    MX_VALGRIND_MEMORY_MAKE_WRITABLE(p, b->size);
    MX_VALGRIND_MEMORY_MAKE_READABLE(p, b->size);
    b->p = *(char**)(b->p);
    b->count++;
  }
  return p;
}

void mx__free_block(mx__block *b, void *p)
{
  MX_VALGRIND_MEMORY_MAKE_NOACCESS(p, b->size);
  MX_VALGRIND_MEMORY_MAKE_WRITABLE(p, sizeof(char*));
  *(char**)p = b->p;
  b->p = p;
  b->count--;
}

void mx__print_chain(mx__block *b)
{
  char *p;

  p = b->p;
  while (p) {
    MX_PRINT(("%p ", p));
    p = *(char**)p;
  }
  MX_PRINT(("\n"));
}
